# Лабиринты
Странное вещество `Items.Weird_Substance`, получаемое при [удобрении](docs/unlocks/fertilizer.md) растений, оказывает необычное воздействие на кусты. Если дрон находится над кустом и ты вызываешь `use_item(Items.Weird_Substance, amount)`, куст превращается в зеленый лабиринт.
Размер лабиринта зависит от количества использованного `Items.Weird_Substance` (второй аргумент вызова `use_item()`).
До улучшения лабиринта использование `n` `Items.Weird_Substance` приводит к созданию лабиринта `n`x`n`. Каждый уровень улучшения удваивает клад, а также необходимое количество `Items.Weird_Substance`.
Итак, вот код для создания лабиринта, охватывающего все поле:

`plant(Entities.Bush)
substance = get_world_size() * 2**(num_unlocked(Unlocks.Mazes) - 1)
use_item(Items.Weird_Substance, substance)`


По какой-то причине дрон не может летать над изгородями, хотя они кажутся не такими уж высокими.

Где-то в изгороди спрятан клад. Примени `harvest()` к кладу, чтобы получить золото в количестве, равном площади лабиринта. (Например, лабиринт 5х5 принесет 25 золота.)

Если ты используешь `harvest()` в любом другом месте, лабиринт пропадет.

`get_entity_type()` равно `Entities.Treasure`, если дрон находится над кладом, и `Entities.Hedge` — во всех остальных местах лабиринта.

Лабиринты не содержат циклов, если только ты не используешь лабиринт повторно (см. ниже, как это сделать). Следовательно, у дрона нет способа оказаться в той же позиции снова, не возвращаясь назад.

Чтобы проверить, есть ли на пути стена, можешь попытаться через нее переместиться.
`move()` возвращает `True`, если попытка удачная, в противном случае — `False`.

`can_move()` можно использовать для проверки наличия стены, не совершая движения.

Если ты не понимаешь, как добраться до клада, посмотри подсказку 1. Она объясняет, как подходить к решению такой задачи.

Использование `measure()` в любом месте лабиринта возвращает позицию клада.
`x, y = measure()`

Если хочешь усложнить задачу, можешь повторно использовать лабиринт, снова применив к кладу то же количество `Items.Weird_Substance`.
Это увеличит количество золота в сундуке на размер площади полного лабиринта и переместит клад в случайную позицию.

Каждый раз, когда клад перемещается, некоторые стены лабиринта могут быть случайным образом удалены. Так что повторно используемые лабиринты могут содержать циклы.

Обрати внимание, что циклы делают лабиринт намного сложнее: ты можешь попадать в уже пройденное место, не возвращаясь назад.
Повторное использование лабиринта не дает больше золота, чем простой сбор в созданном заново лабиринте.
Это задачка со звездочкой, которую ты легко можешь пропустить.
Решай ее, только если знаешь дополнительную информацию и короткие пути, которые помогут пройти лабиринт быстрее.

Один и тот же лабиринт можно решить максимум 301 раз, что соответствует 300 перемещениям. После этого применение странного вещества к кладу больше не будет увеличивать золото в нем, и он больше не будет перемещаться.

<spoiler=показать подсказку 1>Ниже показан общий подход к решению задачи.

Создай лабиринт и представь, что ты дрон.

Подумай, как можно искать клад, если ты в лабиринте.

Опиши стратегию шаг за шагом, чтобы кто-то другой мог воспроизвести ее без раздумий.

Теперь попробуй преобразовать шаги в код.
</spoiler>
<spoiler=показать подсказку 2>Пока нет циклов: все стены на самом деле являются единой большой стеной. Если перемещаться вдоль стены, она проведет тебя через весь лабиринт.
Этот подход не требует длинного кода, и тебе не нужно отслеживать пройденные участки. Около 10 строк кода — вот и все, что тебе понадобится.</spoiler>
<spoiler=показать подсказку 3>Вместо того, чтобы перемещать дрон в абсолютных направлениях, таких как восток или запад, имеет смысл использовать относительные направления, такие как «повернуть направо» или «повернуть налево». Для этого нужно отслеживать, в каком направлении перемещается дрон в текущий момент. Дрон никогда не поворачивает, но ты все равно можешь задать его «виртуальный» поворот в коде.
Тут пригодится следующий трюк с индексами:

`directions = [North, East, South, West]
index = 0`

Используй `% 4`: это позволит дрону вращаться «по кругу», так что после `West` он вернется к `North`.
`# повернуть направо
index = (index + 1) % 4`

`# повернуть налево
index = (index - 1) % 4

move(directions[index])`</spoiler>
<spoiler=показать подсказку 4>Если не получается найти решение, всегда можно использовать менее эффективный способ и не ломать голову.
Решить лабиринт `1`х`1` — задача, не требующая особых усилий.</spoiler>